<?php

namespace Controllers;
use Database;
use Areas;
use PDO;

require_once __DIR__ . '/../Models/Areas.php';

class AreasController
{

    private $db;
    private $area;

    public function __construct()
    {

        $database = new Database();
        $this->db = $database->getConnection();
        $this->area = new Areas($this->db);
    }

    public function index()
    {
        // Obtenemos las mesas y zonas desde el modelo
        $stmtAreas = $this->area->obtenerAreas();
        $stmtImpresoras = $this->area->obtenerImpresoras();

        // Convertimos los resultados en arrays asociativos
        $areas = $stmtAreas->fetchAll(PDO::FETCH_ASSOC);
        $impresoras = $stmtImpresoras->fetchAll(PDO::FETCH_ASSOC);

        // Agrupamos la información en un array de datos
        $data = [
            'areas' => $areas,
            'impresoras' => $impresoras,
        ];
        extract($data);

        require_once __DIR__ . '/../Views/areas/index.php';

    }
    // Método para agregar una zona
    public function agregar()
    {
        if(isset($_POST['nombre'], $_POST['descripcion'], $_POST['id_impresora'])) {
            $nombre      = $_POST['nombre'];
            $descripcion = $_POST['descripcion'];
            $id_impresora = $_POST['id_impresora'];

            $result = $this->area->agregar($nombre, $descripcion, $id_impresora);
            if($result) {
                echo json_encode(['success' => true, 'message' => 'El área ha sido agregada correctamente.']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al agregar El área.']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Datos incompletos.']);
        }
    }
    public function obtener()
    {
        if (isset($_POST['id_area_produccion'])) {
            $id_area = intval($_POST['id_area_produccion']);
            $area = $this->area->obtenerAreasId($id_area);

            if ($area) {
                echo json_encode($area);
            } else {
                echo json_encode(['success' => false, 'message' => 'Área no encontrada.']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'ID de área no proporcionado.']);
        }
    }
    // Método para actualizar una zona
    public function actualizar()
    {
        if(isset($_POST['id_area_produccion'], $_POST['nombre'], $_POST['descripcion'], $_POST['id_impresora'])) {
            $id_area_produccion     = $_POST['id_area_produccion'];
            $nombre      = $_POST['nombre'];
            $descripcion = $_POST['descripcion'];
            $id_impresora = $_POST['id_impresora'];

            $result = $this->area->actualizar($id_area_produccion, $nombre, $descripcion, $id_impresora);
            if($result) {
                echo json_encode(['success' => true, 'message' => 'El área ha sido actualizada correctamente.']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al actualizar el área.']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Datos incompletos.']);
        }
    }

    // Método para eliminar una zona
    public function eliminar()
    {
        if(isset($_POST['id_area_produccion'])) {
            $id_area_produccion = $_POST['id_area_produccion'];

            $result = $this->area->eliminar($id_area_produccion);
            if($result) {
                echo json_encode(['success' => true, 'message' => 'El área ha sido eliminada correctamente.']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al eliminar el área.']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'ID no proporcionado.']);
        }
    }
}