<?php
require_once __DIR__ . '/../Controllers/ZonasController.php';
require_once __DIR__ . '/../Controllers/MesasController.php';
require_once __DIR__ . '/../Controllers/ImpresorasController.php';
require_once __DIR__ . '/../Controllers/AreasController.php';
require_once __DIR__ . '/../Controllers/LoginController.php';
class EnrutadorController
{


    // Método para despachar la solicitud
    public function run()
    {
        
        // Se obtienen los parámetros de la URL, asignando valores predeterminados si no se especifica alguno
        $controllerParam = isset($_GET['controller']) ? $_GET['controller'] : 'home';
        $actionParam = isset($_GET['action']) ? $_GET['action'] : 'index';

        // Se construye el nombre completo del controlador, respetando la nomenclatura
        $controllerClass = '\\Controllers\\' . ucfirst($controllerParam) . 'Controller';

        // Validación de existencia del controlador
        if (!class_exists($controllerClass)) {
            http_response_code(404);
            echo json_encode(['success' => false, 'message' => 'Controlador no encontrado.']);
            exit;
        }

        // Se instancia el controlador
        $controller = new $controllerClass();

        // Validación de existencia de la acción en el controlador
        if (!method_exists($controller, $actionParam)) {
            http_response_code(404);
            echo json_encode(['success' => false, 'message' => 'Acción no encontrada en el controlador.']);
            exit;
        }

        // Se ejecuta la acción solicitada
        $controller->$actionParam();
        exit; // Se termina la ejecución para evitar cargar contenido adicional
    }
}

// Instancia y ejecución del enrutador
$enrutador = new EnrutadorController();
$enrutador->run();