<?php

namespace Controllers;
use Database;
use Impresoras;
use PDO;

require_once __DIR__ . '/../Models/Impresoras.php';

class ImpresorasController
{

    private $db;
    private $impresoras;

    public function __construct()
    {

        $database = new Database();
        $this->db = $database->getConnection();
        $this->impresoras = new Impresoras($this->db);
    }

    public function index()
    {
        // Petición AJAX → JSON para DataTable
        if (isset($_GET['ajax'])) {
            header('Content-Type: application/json');
            $stmt = $this->impresoras->obtenerImpresoras();
            $impresoras = $stmt->fetchAll(PDO::FETCH_ASSOC);
            echo json_encode(['data' => $impresoras]);
            exit;
        }

        // Petición normal → renderiza la vista
        $stmt = $this->impresoras->obtenerImpresoras();
        $list_impresoras = $stmt->fetchAll(PDO::FETCH_ASSOC);

        require_once __DIR__ . '/../Views/impresoras/index.php';
    }
    // Método para agregar una zona
    public function agregar()
    {
        if(isset($_POST['nombre_impresora'], $_POST['ip_local'])) {
            $nombre      = $_POST['nombre_impresora'];
            $ip_local = $_POST['ip_local'];


            $result = $this->impresoras->agregar($nombre, $ip_local);
            if($result) {
                echo json_encode(['success' => true, 'message' => 'La impresoras ha sido agregada correctamente.']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al agregar la impresoras.']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Datos incompletos.']);
        }
    }

    // Método para actualizar una zona
    public function actualizar()
    {
        if(isset($_POST['id_impresora'], $_POST['nombre_impresora'], $_POST['ip_local'])) {
            $id_impresora     = $_POST['id_impresora'];
            $nombre      = $_POST['nombre_impresora'];
            $ip_local = $_POST['ip_local'];


            $result = $this->impresoras->actualizar($id_impresora, $nombre, $ip_local);
            if($result) {
                echo json_encode(['success' => true, 'message' => 'La impresora ha sido actualizada correctamente.']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al actualizar la impresora.']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Datos incompletos.']);
        }
    }
    public function obtener()
    {
        if (isset($_POST['id_impresora'])) {
            $id_impresora = intval($_POST['id_impresora']);
            $zona = $this->impresoras->obtenerImpresorasId($id_impresora);

            if ($zona) {
                echo json_encode($zona);
            } else {
                echo json_encode(['success' => false, 'message' => 'Impresora no encontrada.']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'ID de impresora no proporcionado.']);
        }
    }
    // Método para eliminar una zona
    public function eliminar()
    {
        if(isset($_POST['id_impresora'])) {
            $id_impresora = $_POST['id_impresora'];

            $result = $this->impresoras->eliminar($id_impresora);
            if($result) {
                echo json_encode(['success' => true, 'message' => 'La impresora ha sido eliminada correctamente.']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al eliminar la impresora.']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'ID no proporcionado.']);
        }
    }
}