<?php

namespace Controllers;
use Database;
use Mesas;
use PDO;

require_once __DIR__ . '/../Models/Mesas.php';

class MesasController
{

    private $db;
    private $mesas;

    public function __construct()
    {

        $database = new Database();
        $this->db = $database->getConnection();
        $this->mesas = new Mesas($this->db);
    }

    public function index()
    {
        // Obtenemos las mesas y zonas desde el modelo
        $stmtMesas = $this->mesas->obtenerMesas();
        $stmtZonas = $this->mesas->obtenerZonas();

        // Convertimos los resultados en arrays asociativos
        $mesas = $stmtMesas->fetchAll(PDO::FETCH_ASSOC);
        $zonas = $stmtZonas->fetchAll(PDO::FETCH_ASSOC);

        // Agrupamos la información en un array de datos
        $data = [
            'mesas' => $mesas,
            'zonas' => $zonas,
        ];
        extract($data);

        require_once __DIR__ . '/../Views/mesas/index.php';

    }
    // Método para agregar una zona
    public function agregar()
    {
        if(isset($_POST['nombre'], $_POST['descripcion'], $_POST['id_zona'])) {
            $nombre      = $_POST['nombre'];
            $descripcion = $_POST['descripcion'];
            $id_zona = $_POST['id_zona'];

            $result = $this->mesas->agregar($nombre, $descripcion, $id_zona);
            if($result) {
                echo json_encode(['success' => true, 'message' => 'La mesa ha sido agregada correctamente.']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al agregar la mesa.']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Datos incompletos.']);
        }
    }
    public function obtener()
    {
        if (isset($_POST['id_mesa'])) {
            $id_mesa = intval($_POST['id_mesa']);
            $mesa = $this->mesas->obtenerMesasId($id_mesa);

            if ($mesa) {
                echo json_encode($mesa);
            } else {
                echo json_encode(['success' => false, 'message' => 'Mesa no encontrada.']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'ID de mesa no proporcionado.']);
        }
    }
    // Método para actualizar una zona
    public function actualizar()
    {
        if(isset($_POST['id_mesa'], $_POST['nombre'], $_POST['descripcion'], $_POST['id_zona'])) {
            $id_mesa     = $_POST['id_mesa'];
            $nombre      = $_POST['nombre'];
            $descripcion = $_POST['descripcion'];
            $id_zona = $_POST['id_zona'];

            $result = $this->mesas->actualizar($id_mesa, $nombre, $descripcion, $id_zona);
            if($result) {
                echo json_encode(['success' => true, 'message' => 'La mesa ha sido actualizada correctamente.']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al actualizar la mesa.']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Datos incompletos.']);
        }
    }

    // Método para eliminar una zona
    public function eliminar()
    {
        if(isset($_POST['id_mesa'])) {
            $id_mesa = $_POST['id_mesa'];

            $result = $this->mesas->eliminar($id_mesa);
            if($result) {
                echo json_encode(['success' => true, 'message' => 'La mesa ha sido eliminada correctamente.']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al eliminar la mesa.']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'ID no proporcionado.']);
        }
    }
}