<?php

namespace Controllers;
use Database;
use Zonas;
use PDO;

require_once __DIR__ . '/../Models/Zonas.php';

class ZonasController
{

    private $db;
    private $zonas;

    public function __construct()
    {

        $database = new Database();
        $this->db = $database->getConnection();
        $this->zonas = new Zonas($this->db);
    }

    public function index()
    {
        // Petición AJAX → JSON para DataTable
        if (isset($_GET['ajax'])) {
            header('Content-Type: application/json');
            $stmt = $this->zonas->obtenerZonas();
            $zonas = $stmt->fetchAll(PDO::FETCH_ASSOC);
            echo json_encode(['data' => $zonas]);
            exit;
        }

        // Petición normal → renderiza la vista
        $stmt = $this->zonas->obtenerZonas();
        $list_zonas = $stmt->fetchAll(PDO::FETCH_ASSOC);
        require_once __DIR__ . '/../Views/zonas/index.php';
    }
    // Método para agregar una zona
    public function agregar()
    {
        if(isset($_POST['nombre'], $_POST['descripcion'])) {
            $nombre      = $_POST['nombre'];
            $descripcion = $_POST['descripcion'];


            $result = $this->zonas->agregar($nombre, $descripcion);
            if($result) {
                echo json_encode(['success' => true, 'message' => 'La zona ha sido agregada correctamente.']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al agregar la zona.']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Datos incompletos.']);
        }
    }

    // Método para actualizar una zona
    public function actualizar()
    {
        if(isset($_POST['id_zona'], $_POST['nombre'], $_POST['descripcion'])) {
            $id_zona     = $_POST['id_zona'];
            $nombre      = $_POST['nombre'];
            $descripcion = $_POST['descripcion'];


            $result = $this->zonas->actualizar($id_zona, $nombre, $descripcion);
            if($result) {
                echo json_encode(['success' => true, 'message' => 'La zona ha sido actualizada correctamente.']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al actualizar la zona.']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'Datos incompletos.']);
        }
    }
    public function obtener()
    {
        if (isset($_POST['id_zona'])) {
            $id_zona = intval($_POST['id_zona']);
            $zona = $this->zonas->obtenerZona($id_zona);

            if ($zona) {
                echo json_encode($zona);
            } else {
                echo json_encode(['success' => false, 'message' => 'Zona no encontrada.']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'ID de zona no proporcionado.']);
        }
    }
    // Método para eliminar una zona
    public function eliminar()
    {
        if(isset($_POST['id_zona'])) {
            $id_zona = $_POST['id_zona'];

            $result = $this->zonas->eliminar($id_zona);
            if($result) {
                echo json_encode(['success' => true, 'message' => 'La zona ha sido eliminada correctamente.']);
            } else {
                echo json_encode(['success' => false, 'message' => 'Error al eliminar la zona.']);
            }
        } else {
            echo json_encode(['success' => false, 'message' => 'ID no proporcionado.']);
        }
    }
}