<?php
class UrlBase
{
    public string $baseUrl;
    public string $currentController;

    public function __construct()
    {
        $this->baseUrl           = $this->obtenerBaseUrl();
        $this->currentController = $this->obtenerCurrentController();
    }

    /**
     * Devuelve la ruta base del proyecto (útil para construir URLs absolutas).
     */
    private function obtenerBaseUrl(): string
    {
        return '/restaurante';
    }

    /**
     * Extrae el nombre del controlador desde la URL amigable:
     * Ejemplo: /restaurante/zonas → retorna "zonas"
     */
    private function obtenerCurrentController(): string
    {
        $requestUri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
        $segments   = explode('/', trim($requestUri, '/'));
        return $segments[1] ?? '';
    }


}

