<?php
$file = realpath(dirname(__FILE__) . '/../Connection/database.php');
require_once($file);

class Areas
{
    private $conn;

    public function __construct($db)
    {
        $this->conn = $db;
    }

    public function obtenerAreas()
    {
        $query = "SELECT areas_produccion.`id_area_produccion`, areas_produccion.nombre, areas_produccion.descripcion, areas_produccion.activo, impresoras.`nombre_impresora` AS impresoras FROM `areas_produccion` 
INNER JOIN impresoras ON areas_produccion.`id_impresora`=impresoras.`id_impresora`
WHERE areas_produccion.activo = 'activo' order by areas_produccion.`id_area_produccion` desc";
        $stmt = $this->conn->prepare($query);

        if ($stmt->execute()) {
            return $stmt;
        } else {
            return null;
        }
    }
    public function obtenerImpresoras() {
        $query = "SELECT id_impresora, nombre_impresora, ip_local, activo FROM impresoras where activo = 'activo' order by nombre_impresora desc"; ;
        $stmt = $this->conn->prepare($query);

        if ($stmt->execute()) {
            return $stmt;
        } else {
            return null;
        }
    }
    public function obtenerAreasId(int $id_area)
    {

        $sql = "
        SELECT id_area_produccion, nombre, descripcion, id_impresora
        FROM areas_produccion
        WHERE id_area_produccion = :id_area
          AND activo = 'activo'
        LIMIT 1
    ";

        $stmt = $this->conn->prepare($sql);
        $stmt->bindValue(':id_area', $id_area, PDO::PARAM_INT);

        if ($stmt->execute()) {
            return $stmt->fetch(PDO::FETCH_ASSOC) ?: null;
        }

        return null;
    }

    public function agregar($nombre, $descripcion, $id_impresora)
    {
        $activo = 'activo';
        $query = "INSERT INTO areas_produccion (nombre, descripcion, id_impresora, activo) VALUES (:nombre, :descripcion, :id_impresora, :activo)";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':nombre', $nombre);
        $stmt->bindParam(':descripcion', $descripcion);
        $stmt->bindParam(':id_impresora', $id_impresora);
        $stmt->bindParam(':activo', $activo);
        return $stmt->execute();
    }

    public function actualizar($id_area, $nombre, $descripcion, $id_impresora)
    {
        $query = "UPDATE areas_produccion SET nombre = :nombre, descripcion = :descripcion, id_impresora = :id_impresora WHERE id_area_produccion = :id_area";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':nombre', $nombre);
        $stmt->bindParam(':descripcion', $descripcion);
        $stmt->bindParam(':id_impresora', $id_impresora);
        $stmt->bindParam(':id_area', $id_area);

        return $stmt->execute();
    }

    public function eliminar($id_area_produccion)
    {
        // Actualiza el estado del registro a '0' (inactivo) en lugar de eliminarlo físicamente
        $query = "UPDATE areas_produccion SET activo = 'inactivo' WHERE id_area_produccion = :id_area_produccion";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':id_area_produccion', $id_area_produccion);
        return $stmt->execute();
    }
}
