<?php
$file = realpath(dirname(__FILE__) . '/../Connection/database.php');
require_once($file);

class Impresoras
{
    private $conn;

    public function __construct($db) {
        $this->conn = $db;
    }

    public function obtenerImpresoras() {
        $query = "SELECT id_impresora, nombre_impresora, ip_local, activo FROM impresoras where activo = 'activo' order by id_impresora desc"; ;
        $stmt = $this->conn->prepare($query);

        if ($stmt->execute()) {
            return $stmt;
        } else {
            return null;
        }
    }
    public function obtenerImpresorasId(int $id_impresora)
    {
        $sql = "
        SELECT id_impresora, nombre_impresora, ip_local
        FROM impresoras
        WHERE id_impresora = :id_impresora
          AND activo = 'activo'
        LIMIT 1
    ";

        $stmt = $this->conn->prepare($sql);
        $stmt->bindValue(':id_impresora', $id_impresora, PDO::PARAM_INT);

        if ($stmt->execute()) {
            return $stmt->fetch(PDO::FETCH_ASSOC) ?: null;
        }

        return null;
    }
    public function agregar($nombre_impresora, $ip_local) {
        $activo = 'activo';
        $query = "INSERT INTO impresoras (nombre_impresora, ip_local, activo) VALUES (:nombre_impresora, :ip_local, :activo)";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':nombre_impresora', $nombre_impresora);
        $stmt->bindParam(':ip_local', $ip_local);
        $stmt->bindParam(':activo', $activo);
        return $stmt->execute();
    }

    public function actualizar($id_impresora, $nombre_impresora, $ip_local) {
        $query = "UPDATE impresoras SET nombre_impresora = :nombre_impresora, ip_local = :ip_local WHERE id_impresora = :id_impresora";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':nombre_impresora', $nombre_impresora);
        $stmt->bindParam(':ip_local', $ip_local);
        $stmt->bindParam(':id_impresora', $id_impresora);
        return $stmt->execute();
    }

    public function eliminar($id_impresora) {
        // Actualiza el estado del registro a '0' (inactivo) en lugar de eliminarlo físicamente
        $query = "UPDATE impresoras SET activo = 'inactivo' WHERE id_impresora = :id_impresora";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':id_impresora', $id_impresora);
        return $stmt->execute();
    }
}
