<?php
$file = realpath(dirname(__FILE__) . '/../Connection/database.php');
require_once($file);

class Mesas
{
    private $conn;

    public function __construct($db) {
        $this->conn = $db;
    }

    public function obtenerMesas() {
        $query = "SELECT mesas.id_mesa, mesas.nombre, mesas.descripcion, mesas.activo,zonas.nombre as zonas FROM mesas inner join zonas on mesas.id_zona=zonas.id_zona where mesas.activo = 'activo' order by  mesas.id_mesa desc"; ;
        $stmt = $this->conn->prepare($query);

        if ($stmt->execute()) {
            return $stmt;
        } else {
            return null;
        }
    }
    public function obtenerZonas() {
        $query = "SELECT id_zona, nombre, descripcion, activo FROM zonas where activo = 'activo' order by nombre desc"; ;
        $stmt = $this->conn->prepare($query);

        if ($stmt->execute()) {
            return $stmt;
        } else {
            return null;
        }
    }
    public function obtenerMesasId(int $id_mesa)
    {

        $sql = "
        SELECT id_mesa, nombre, descripcion, id_zona
        FROM mesas
        WHERE id_mesa = :id_mesa
          AND activo = 'activo'
        LIMIT 1
    ";

        $stmt = $this->conn->prepare($sql);
        $stmt->bindValue(':id_mesa', $id_mesa, PDO::PARAM_INT);

        if ($stmt->execute()) {
            return $stmt->fetch(PDO::FETCH_ASSOC) ?: null;
        }

        return null;
    }
    public function agregar($nombre, $descripcion,$id_zona) {
        $activo = 'activo';
        $query = "INSERT INTO mesas (nombre, descripcion,id_zona, activo) VALUES (:nombre, :descripcion, :id_zona, :activo)";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':nombre', $nombre);
        $stmt->bindParam(':descripcion', $descripcion);
        $stmt->bindParam(':id_zona', $id_zona);

        $stmt->bindParam(':activo', $activo);
        return $stmt->execute();
    }

    public function actualizar($id_mesa, $nombre, $descripcion, $id_zona) {
        $query = "UPDATE mesas SET nombre = :nombre, descripcion = :descripcion, id_zona=:id_zona WHERE id_mesa = :id_mesa";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':nombre', $nombre);
        $stmt->bindParam(':descripcion', $descripcion);
        $stmt->bindParam(':id_zona', $id_zona);

        $stmt->bindParam(':id_mesa', $id_mesa);
        return $stmt->execute();
    }

    public function eliminar($id_mesa) {
        // Actualiza el estado del registro a '0' (inactivo) en lugar de eliminarlo físicamente
        $query = "UPDATE mesas SET activo = 'inactivo' WHERE id_mesa = :id_mesa";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':id_mesa', $id_mesa);
        return $stmt->execute();
    }
}
