<?php
$file = realpath(dirname(__FILE__) . '/../Connection/database.php');
require_once($file);

class Zonas
{
    private $conn;

    public function __construct($db) {
        $this->conn = $db;
    }

    public function obtenerZonas() {
        $query = "SELECT id_zona, nombre, descripcion, activo FROM zonas where activo = 'activo' order by id_zona desc"; ;
        $stmt = $this->conn->prepare($query);

        if ($stmt->execute()) {
            return $stmt;
        } else {
            return null;
        }
    }
    public function obtenerZona(int $id_zona)
    {
        $sql = "
        SELECT id_zona, nombre, descripcion
        FROM zonas
        WHERE id_zona = :id_zona
          AND activo = 'activo'
        LIMIT 1
    ";

        $stmt = $this->conn->prepare($sql);
        $stmt->bindValue(':id_zona', $id_zona, PDO::PARAM_INT);

        if ($stmt->execute()) {
            return $stmt->fetch(PDO::FETCH_ASSOC) ?: null;
        }

        return null;
    }

    public function agregar($nombre, $descripcion) {
        $activo = 'activo';
        $query = "INSERT INTO zonas (nombre, descripcion, activo) VALUES (:nombre, :descripcion, :activo)";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':nombre', $nombre);
        $stmt->bindParam(':descripcion', $descripcion);
        $stmt->bindParam(':activo', $activo);
        return $stmt->execute();
    }

    public function actualizar($id_zona, $nombre, $descripcion) {
        $query = "UPDATE zonas SET nombre = :nombre, descripcion = :descripcion WHERE id_zona = :id_zona";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':nombre', $nombre);
        $stmt->bindParam(':descripcion', $descripcion);
        $stmt->bindParam(':id_zona', $id_zona);
        return $stmt->execute();
    }

    public function eliminar($id_zona) {
        // Actualiza el estado del registro a '0' (inactivo) en lugar de eliminarlo físicamente
        $query = "UPDATE zonas SET activo = 'inactivo' WHERE id_zona = :id_zona";
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':id_zona', $id_zona);
        return $stmt->execute();
    }
}
