document.addEventListener('DOMContentLoaded', () => {

    document.querySelectorAll('.edit-btn').forEach(btn => {
        btn.addEventListener('click', () => {
            const idArea = btn.getAttribute('data-id');
            const formData = new FormData();
            formData.append('id_area_produccion', idArea);

            fetch('/restaurante/?controller=areas&action=obtener', {
                method: 'POST',
                body: formData
            })
                .then(response => response.json())
                .then(data => {
                    // Poblar formulario
                    const form = document.getElementById('editForm');
                    form.elements['id_area_produccion'].value = data.id_area_produccion;
                    form.elements['nombre'].value = data.nombre;
                    form.elements['descripcion'].value = data.descripcion;
                    form.elements['id_impresora'].value = data.id_impresora;
                })
                .catch(error => {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'No se pudieron cargar los datos para editar'
                    });
                });
        });
    });


// Inicialización de la validación para el formulario de agregar zona
    $("#addForm").validate({
        rules: {
            nombre: {
                required: true,
                minlength: 3
            },
            descripcion: {
                required: true,
                minlength: 5
            },
            id_impresora: {
                required: true
            }
        },
        messages: {
            nombre: {
                required: "Por favor, ingrese un nombre",
                minlength: "El nombre debe tener al menos 3 caracteres"
            },
            descripcion: {
                required: "Por favor, ingrese una descripción",
                minlength: "La descripción debe tener al menos 5 caracteres"
            },
            id_impresora: {
                required: "Seleccione una impresora"
            }
        },
        errorElement: "div",
        errorClass: "invalid-feedback",
        highlight(element) {
            $(element).addClass("is-invalid");
        },
        unhighlight(element) {
            $(element).removeClass("is-invalid");
        },
        submitHandler(form) {
            const formData = new FormData(form);
            fetch('/restaurante/areas/agregar', {
                method: 'POST',
                body: formData
            })
                .then(response => response.json())
                .then(data => procesarRespuesta(data, 'Área agregada'))
                .catch(() => {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Ocurrió un error en la solicitud'
                    });
                });
        }
    });
    // Función para procesar respuestas de fetch
    const procesarRespuesta = (data, mensajeExito) => {
        if(data.success) {
            Swal.fire({
                icon: 'success',
                title: mensajeExito,
                text: data.message
            }).then(() => {
                location.reload();
            });
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: data.message
            });
        }
    };

    $('.modal .btn-primary[type="submit"]').on('click', function(e){
        // Identifica el modal activo
        var $form = $(this).closest('.modal').find('form');
        var formClass = $form.attr('id');

        // Aplica la validación en el modal identificado
        aplicarValidacionEnModal(formClass);
        var formularioSelector = '#' + formClass;
        console.log($(formularioSelector).valid());
        // Fuerza la validación y, si falla, evita el envío del formulario
        if (!$(formularioSelector).valid()) {
            e.preventDefault();
            return false;
        }
    });


    function aplicarValidacionEnModal(modalId) {
        var formularioSelector='#'+modalId;

        $(formularioSelector).attr('novalidate', 'novalidate');
        // Evita inicializar el validador más de una vez
        if (!$(formularioSelector).data("validator")) {
            $(formularioSelector).validate({
                rules: {
                    nombre: {
                        required: true,
                        minlength: 3
                    },
                    descripcion: {
                        required: true,
                        minlength: 5
                    },
                    id_impresora: {
                        required: true
                    }
                },
                messages: {
                    nombre: {
                        required: "Ingrese un nombre",
                        minlength: "El nombre debe tener al menos 3 caracteres"
                    },
                    descripcion: {
                        required: "Ingrese una descripción",
                        minlength: "La descripción debe tener al menos 5 caracteres"
                    },
                    id_impresora: {
                        required: "Seleccione una impresora"
                    }
                },
                errorElement: "div",
                errorClass: "invalid-feedback",
                highlight: function(element) {
                    $(element).addClass("is-invalid");
                },
                unhighlight: function(element) {
                    $(element).removeClass("is-invalid");
                },
                submitHandler: function(form) {
                    const formData = new FormData(form);
                    fetch('/restaurante/areas/actualizar', {
                        method: 'POST',
                        body: formData
                    })
                        .then(response => response.json())
                        .then(data => procesarRespuesta(data, 'Área actualizada'))
                        .catch(error => {
                            console.error('Error en la solicitud:', error);
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: 'Ocurrió un error en la solicitud'
                            });
                        });
                }
            });
        }
    }

    // Eliminar Zona
    document.querySelectorAll('.deleteForm').forEach(form => {
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            const formData = new FormData(this);
            fetch('/restaurante/areas/eliminar', {
                method: 'POST',
                body: formData
            })
                .then(response => response.json())
                .then(data => procesarRespuesta(data, 'Área eliminada'))
                .catch(error => {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Ocurrió un error en la solicitud'
                    });
                });
        });
    });

});