document.addEventListener('DOMContentLoaded', () => {

    document.querySelectorAll('.edit-btn').forEach(btn => {
        btn.addEventListener('click', () => {
            const idImpresora = btn.getAttribute('data-id');
            const formData = new FormData();
            formData.append('id_impresora', idImpresora);

            fetch('/restaurante/?controller=impresoras&action=obtener', {
                method: 'POST',
                body: formData
            })
                .then(response => response.json())
                .then(data => {
                    // Poblar formulario
                    const form = document.getElementById('editForm');
                    form.elements['id_impresora'].value = data.id_impresora;
                    form.elements['nombre_impresora'].value = data.nombre_impresora;
                    form.elements['ip_local'].value = data.ip_local;
                })
                .catch(error => {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'No se pudieron cargar los datos para editar'
                    });
                });
        });
    });

// Inicialización de la validación para el formulario de agregar zona
    $("#addForm").validate({
        rules: {
            nombre_impresora: {
                required: true,
                minlength: 3
            },
            ip_local: {
                required: true,
                minlength: 5
            }
        },
        messages: {
            nombre: {
                required: "Por favor, ingrese un nombre",
                minlength: "El nombre debe tener al menos 3 caracteres"
            },
            ip_local: {
                required: "Por favor, ingrese una descripción",
                minlength: "La descripción debe tener al menos 5 caracteres"
            }
        },
        errorElement: "div",
        errorClass: "invalid-feedback",
        highlight: function(element) {
            $(element).addClass("is-invalid");
        },
        unhighlight: function(element) {
            $(element).removeClass("is-invalid");
        },
        submitHandler: function(form) {

            const formData = new FormData(form);

            fetch('/restaurante/impresoras/agregar', {
                method: 'POST',
                body: formData
            })
                .then(response => response.json())
                .then(data => procesarRespuesta(data, 'Impresora agregada'))
                .catch(error => {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Ocurrió un error en la solicitud'
                    });
                });
        }

    });
    // Función para procesar respuestas de fetch
    const procesarRespuesta = (data, mensajeExito) => {
        console.log(data);
        if(data.success) {
            Swal.fire({
                icon: 'success',
                title: mensajeExito,
                text: data.message
            }).then(() => {
                location.reload();
            });
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: data.message
            });
        }
    };
    $('.modal .btn-primary[type="submit"]').on('click', function(e){
        // Identifica el modal activo
        var $form = $(this).closest('.modal').find('form');
        var formClass = $form.attr('id');

        // Aplica la validación en el modal identificado
        aplicarValidacionEnModal(formClass);
        var formularioSelector = '#' + formClass;
        console.log($(formularioSelector).valid());
        // Fuerza la validación y, si falla, evita el envío del formulario
        if (!$(formularioSelector).valid()) {
            e.preventDefault();
            return false;
        }
    });


    function aplicarValidacionEnModal(modalId) {
        var formularioSelector='#'+modalId;

        $(formularioSelector).attr('novalidate', 'novalidate');
        // Evita inicializar el validador más de una vez
        if (!$(formularioSelector).data("validator")) {
            $(formularioSelector).validate({
                rules: {
                    nombre_impresora: {
                        required: true,
                        minlength: 3
                    },
                    ip_local: {
                        required: true,
                        minlength: 5
                    }
                },
                messages: {
                    nombre: {
                        required: "Ingrese un nombre",
                        minlength: "El nombre debe tener al menos 3 caracteres"
                    },
                    ip_local: {
                        required: "Ingrese una descripción",
                        minlength: "La descripción debe tener al menos 5 caracteres"
                    }
                },
                errorElement: "div",
                errorClass: "invalid-feedback",
                highlight: function(element) {
                    $(element).addClass("is-invalid");
                },
                unhighlight: function(element) {
                    $(element).removeClass("is-invalid");
                },
                submitHandler: function(form) {
                    const formData = new FormData(form);
                    fetch('/restaurante/impresoras/actualizar', {
                        method: 'POST',
                        body: formData
                    })
                        .then(response => response.json())
                        .then(data => procesarRespuesta(data, 'Impresora actualizada'))
                        .catch(error => {
                            console.error('Error en la solicitud:', error);
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: 'Ocurrió un error en la solicitud'
                            });
                        });
                }
            });
        }
    }

    // Eliminar Zona
    document.querySelectorAll('.deleteForm').forEach(form => {
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            const formData = new FormData(this);
            fetch('/restaurante/impresoras/eliminar', {
                method: 'POST',
                body: formData
            })
                .then(response => response.json())
                .then(data => procesarRespuesta(data, 'Impresora eliminada'))
                .catch(error => {
                    Swal.fire({
                        icon: 'error',
                        title: 'Error',
                        text: 'Ocurrió un error en la solicitud'
                    });
                });
        });
    });

});