<?php
require_once realpath(dirname(__FILE__) . '/../../Models/Usuario.php');
require_once realpath(dirname(__FILE__) . '/../../controllers/UsuarioControlador.php');

require_once realpath(dirname(__FILE__) . '/../../util/mensajes.php');
require_once realpath(dirname(__FILE__) . '/../../util/mail.php');

$estadoRegistro = "";

if (isset($_GET['uri'])) {
  $usuarioModel = new Usuario();
  $usuarioController = new UsuarioControlador($usuarioModel);

  $uri = $_GET['uri'];

  $_POST["link_activacion"] = $uri;

  $resultadoConsultarEstadoCuentaUsuario = $usuarioController->consultarEstadoCuentaUsuario($_POST);

  if (count($resultadoConsultarEstadoCuentaUsuario) == 1) {
    $_POST["correo_electronico"] = $resultadoConsultarEstadoCuentaUsuario[0]["email"];
    $usuarioController->activarCuentaUsuario($_POST);
    $estadoRegistro = getMessage(200, "¡Atención!", "Se activó su cuenta de manera exitosa, proceda a iniciar sesión");
  } else {
    $estadoRegistro = getMessage(404, "¡Atención!", "Este link de activación ha expirado");
  }
} else {
  $estadoRegistro = getMessage(500, "¡Atención!", "Ud. no cuenta con autorización para acceder a esta página");
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Cofi - Sistema Contable</title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet"
    href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&amp;display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../src/css/fontawesome-all.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../src/css/adminlte.min.css">
</head>

<body class="hold-transition login-page">
  <div class="login-box">
    <div class="login-logo p-3">
      <img src="../src/img/cofi_h_c.png" height="65" />
    </div>
    <!-- /.login-logo -->
    <div class="card">
      <div class="card-body login-card-body">
        <?php echo $estadoRegistro; ?>
        <div class="mt-2 text-center">
          <a href="login.php" class="text-center">Iniciar Sesión</a>
        </div>
      </div>
      <!-- /.login-card-body -->
    </div>
  </div>
  <!-- /.login-box -->

  <!-- jQuery -->
  <script src="../src/js/jquery.min.js"></script>
  <!-- AdminLTE App -->
  <script src="../src/js/adminlte.min.js"></script>
</body>

</html>