<?php
session_start();
require_once realpath(dirname(__FILE__) . '/../../Models/Zonas.php');

require_once realpath(dirname(__FILE__) . '/../../Helpers/uri.php');
// Instanciar UrlBase
$uri = new UrlBase();

// Obtener ruta base y controlador actual
$baseUrl = $uri->baseUrl;
$currentController = $uri->currentController;


$estadoRegistro = "";

if (isset($_SESSION) && !empty($_SESSION)) {
  session_unset();
  session_destroy();
}

if (isset($_POST) && !empty($_POST)) {
  $usuarioModel = new Usuario();
  $usuarioController = new UsuarioControlador($usuarioModel);
  $clienteCofiModel = new ClienteCofi();
  $clienteCofiController = new ClienteCofiControlador($clienteCofiModel);

  $resultadoIniciarSesionUsuario = $usuarioController->iniciarSesionUsuario($_POST);

  if (count($resultadoIniciarSesionUsuario) == 1) {
    if ($resultadoIniciarSesionUsuario[0]["estado"] == 1) {
      $_SESSION["id_usuario"] = $resultadoIniciarSesionUsuario[0]["id_usuario"];
      $_SESSION["email"] = $resultadoIniciarSesionUsuario[0]["email"];

      $resultadoListarInformacionClienteCofi = $clienteCofiController->listarInformacionClienteCofi($resultadoIniciarSesionUsuario[0]["id_usuario"]);

      //$_SESSION["ruc"] = $resultadoListarInformacionClienteCofi[0]["ruc"];
      $_SESSION["razon_social"] = $resultadoListarInformacionClienteCofi[0]["razon_social"];
      $_SESSION["client_id"] = encriptarCadena($resultadoListarInformacionClienteCofi[0]["client_id"]);
      $_SESSION["client_secret"] = encriptarCadena($resultadoListarInformacionClienteCofi[0]["client_secret"]);
      $_SESSION["usuario_sol"] = encriptarCadena($resultadoListarInformacionClienteCofi[0]["usuario_sol"]);
      $_SESSION["clave_sol"] = encriptarCadena($resultadoListarInformacionClienteCofi[0]["clave_sol"]);

      $estadoRegistro = getMessage(200, "¡Atención!", "Credenciales correctas");

      header('Location: selecciona-empresa.php');
      exit;
    } else if ($resultadoIniciarSesionUsuario[0]["estado"] == -1) {
      $estadoRegistro = getMessage(500, "¡Atención!", "Pendiente activación de cuenta, verifique el correo electrónico que registró");
    } else if ($resultadoIniciarSesionUsuario[0]["estado"] == 0) {
      $estadoRegistro = getMessage(404, "¡Atención!", "Esta cuenta se encuentra inactiva. Contáctese a soporte.");
    }
  } else {
    $estadoRegistro = getMessage(404, "¡Atención!", "Credenciales incorrectas");
  }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Cofi - Sistema Contable</title>
    <base href="/restaurante/Views/">
    <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet"
    href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&amp;display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="src/css/fontawesome-all.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="src/css/adminlte.min.css">
</head>

<body class="hold-transition login-page">
  <div class="login-box">
    <div class="login-logo p-3">
      <img src="src/img/cofi_h_c.png" height="65" />
    </div>
    <!-- /.login-logo -->
    <div class="card">
      <div class="card-body login-card-body">
        <p class="login-box-msg">Inicie sesión con su correo electrónico</p>

        <form action="login.php" method="post">
          <div class="input-group mb-3">
            <input autocomplete="off" type="email" name="email" class="form-control" placeholder="Correo electrónico">
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-envelope"></span>
              </div>
            </div>
          </div>
          <div class="input-group mb-3">
            <input autocomplete="off" type="password" name="clave" class="form-control" placeholder="Contraseña">
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-lock"></span>
              </div>
            </div>
          </div>
          <div class="row">
            <!-- /.col -->
            <div class="col">
              <div class="mb-2 text-right">
                <a href="olvide-clave.php">Olvidé mi contraseña</a>
              </div>
                <a href="<?= $baseUrl ?>/zonas" type="submit" class="btn btn-primary btn-block">Iniciar Sesión</a>

            </div>
            <!-- /.col -->
          </div>
        </form>
        <div class="mt-2">
          <a href="" class="text-center">Regístrate ahora</a>
        </div>
        <?php echo $estadoRegistro; ?>
      </div>
      <!-- /.login-card-body -->
    </div>
  </div>
  <!-- /.login-box -->

  <!-- jQuery -->
  <script src="src/js/jquery.min.js"></script>
  <!-- AdminLTE App -->
  <script src="src/js/adminlte.min.js"></script>
</body>

</html>