<?php
require_once realpath(dirname(__FILE__) . '/../../Models/ClienteCofi.php');
require_once realpath(dirname(__FILE__) . '/../../controllers/ClienteCofiControlador.php');
require_once realpath(dirname(__FILE__) . '/../../util/mensajes.php');

$estadoRegistro = "";

if (isset($_POST) && !empty($_POST)) {
  $clienteCofiModel = new ClienteCofi();
  $clienteCofiController = new ClienteCofiControlador($clienteCofiModel);

  $resultadoEmailClienteCofiController = $clienteCofiController->consultarEmailClienteCofiPublico($_POST);
  $resultadoRucClienteCofiController = $clienteCofiController->consultarRucClienteCofiPublico($_POST);

  if (count($resultadoEmailClienteCofiController) == 1 && count($resultadoRucClienteCofiController) == 1) {
    session_start();
    $_SESSION["email"] = $resultadoEmailClienteCofiController[0]["email"];
    $estadoRegistro = getMessage(200, "¡Atención!", "Credenciales validadas");

    header('Location: recuperar-clave.php');
  } else {
    $estadoRegistro = getMessage(500, "¡Atención!", "Los datos ingresados no coinciden");
  }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Cofi | Olvidé clave</title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&amp;display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../src/css/fontawesome-all.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../src/css/adminlte.min.css">
</head>

<body class="hold-transition login-page">
  <div class="login-box">
    <div class="login-logo p-3">
      <img src="../src/img/cofi_h_c.png" height="65" />
    </div>
    <!-- /.login-logo -->
    <div class="card">
      <div class="card-body login-card-body">
        <p class="login-box-msg">¿Olvidaste tu contraseña?<br> Ingresa el correo electrónico de tu cuenta</p>

        <form action="olvide-clave.php" method="post">
          <div class="input-group mb-3">
            <input autocomplete="off" type="number" class="form-control" name="ruc" placeholder="RUC (SUNAT)">
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-id-card"></span>
              </div>
            </div>
          </div>
          <div class="input-group mb-3">
            <input autocomplete="off" type="email" class="form-control" name="correo_electronico" placeholder="Email">
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-envelope"></span>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-12">
              <button type="submit" class="btn btn-primary btn-block">Recuperar contraseña</button>
            </div>
            <!-- /.col -->
          </div>
        </form>
        <?php echo $estadoRegistro; ?>

        <p class="mt-3 mb-1">
          <a href="index.php">Iniciar sesión</a>
        </p>
        <p class="mb-0">
          <a href="registro-usuario.php" class="text-center">Regístrate ahora</a>
        </p>
      </div>
      <!-- /.login-card-body -->
    </div>
  </div>
  <!-- /.login-box -->


  <!-- jQuery -->
  <script src="../src/js/jquery.min.js"></script>
  <!-- AdminLTE App -->
  <script src="../src/js/adminlte.min.js"></script>
</body>

</html>