<?php
session_start();

require_once realpath(dirname(__FILE__) . '/../../Models/Usuario.php');
require_once realpath(dirname(__FILE__) . '/../../controllers/UsuarioControlador.php');
require_once realpath(dirname(__FILE__) . '/../../util/mensajes.php');

$estadoRegistro = "";
if (isset($_SESSION["email"])) {
  if (isset($_POST) && !empty($_POST)) {
    $usuarioModel = new Usuario();
    $usuarioController = new UsuarioControlador($usuarioModel);

    if ($_POST["repetir_clave"] == $_POST["clave"]) {
      $_POST["email"] = $_SESSION["email"];
      $resultadoRegistrarClienteCofiPublico = $usuarioController->actualizarClaveUsuario($_POST);
      $estadoRegistro = getMessage(200, "Aviso", "Sus credenciales se actualizaron de manera satisfactoria");
      session_unset();
      session_destroy();
    } else {
      $estadoRegistro = getMessage(500, "¡Atención!", "Las claves ingresadas no coinciden");
    }
  }
} else {
  header('Location: login.php');
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Cofi | Recuperar clave</title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&amp;display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../src/css/fontawesome-all.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../src/css/adminlte.min.css">

<body class="hold-transition login-page">
  <div class="login-box">
    <div class="login-logo p-3">
      <img src="../src/img/cofi_h_c.png" height="65" />
    </div>
    <!-- /.login-logo -->
    <div class="card">
      <div class="card-body login-card-body">
        <?php
        if ($estadoRegistro == "") {
        ?>
          <p class="login-box-msg">A continuación escribe una nueva contraseña para recuperarla</p>

          <form action="recuperar-clave.php" method="post">
            <div class="input-group mb-3">
              <input autocomplete="off" type="password" name="clave" class="form-control" placeholder="Nueva contraseña">
              <div class="input-group-append">
                <div class="input-group-text">
                  <span class="fas fa-lock"></span>
                </div>
              </div>
            </div>
            <div class="input-group mb-3">
              <input autocomplete="off" type="password" name="repetir_clave" class="form-control" placeholder="Confirmar contraseña">
              <div class="input-group-append">
                <div class="input-group-text">
                  <span class="fas fa-lock"></span>
                </div>
              </div>
            </div>
            <div class="row">
              <div class="col-12">
                <button type="submit" class="btn btn-primary btn-block">Cambiar contraseña</button>
              </div>
              <!-- /.col -->
            </div>
          </form>
        <?php
        } else {
        ?>

          <p class="mt-3 mb-1">
            <a href="index.php">Iniciar Sesión</a>
          </p>
        <?php echo $estadoRegistro;
        } ?>
      </div>
      <!-- /.login-card-body -->
    </div>
  </div>
  <!-- /.login-box -->

  <!-- jQuery -->
  <script src="../src/js/jquery.min.js"></script>
  <!-- AdminLTE App -->
  <script src="../src/js/adminlte.min.js"></script>
</body>

</html>