<?php
require_once realpath(dirname(__FILE__) . '/../../Models/Usuario.php');
require_once realpath(dirname(__FILE__) . '/../../Models/ClienteCofi.php');
require_once realpath(dirname(__FILE__) . '/../../controllers/UsuarioControlador.php');
require_once realpath(dirname(__FILE__) . '/../../controllers/ClienteCofiControlador.php');
require_once realpath(dirname(__FILE__) . '/../../controllers/MainTransactionController.php');

require_once realpath(dirname(__FILE__) . '/../../util/mensajes.php');
require_once realpath(dirname(__FILE__) . '/../../util/cadenas.php');
require_once realpath(dirname(__FILE__) . '/../../util/mail.php');

$estadoRegistro = "";

if (isset($_POST) && !empty($_POST)) {
  $usuarioModel = new Usuario();
  $usuarioController = new UsuarioControlador($usuarioModel);
  $clienteCofiModel = new ClienteCofi();
  $clienteCofiController = new ClienteCofiControlador($clienteCofiModel);

  $resultadoEmailClienteCofiController = $clienteCofiController->consultarEmailClienteCofiPublico($_POST);
  $resultadoRucClienteCofiController = $clienteCofiController->consultarRucClienteCofiPublico($_POST);

  if (count($resultadoEmailClienteCofiController) > 0) {
    $estadoRegistro = getMessage(500, "¡Atención!", "Ya existe una cuenta con el correo electrónico ingresado");
  } else if (count($resultadoRucClienteCofiController) > 0) {
    $estadoRegistro = getMessage(500, "¡Atención!", "Ya existe una cuenta con el RUC ingresado");
  } else {
    if (isset($_POST['chk_terminos'])) {
      if ($_POST["repetir_clave"] == $_POST["clave"]) {
        $bd = new DataBase();
        $mainTransactionController = new MainTransactionController($bd);
        $mainTransactionController->beginTransaction();
        try {
          $resultadoRegistrarClienteCofiPublico = $clienteCofiController->registrarClienteCofiPublico($_POST, $bd);

          if ($resultadoRegistrarClienteCofiPublico != -1) {
            $_POST['id_cliente_cofi'] = $resultadoRegistrarClienteCofiPublico;
            $resultadoRegistrarUsuarioPublico = $usuarioController->registrarUsuarioPublico($_POST, $bd);

            $mensajeCorreo = "<p>Hola " . $_POST["razon_social"] . ", para que culmines la creación de tu cuenta debes activarla, ingresa a este enlace para hacerlo: 
            <a href='https://dodotec.alwaysdata.net/cofi/views/usuario/activar-cuenta.php?uri=" . encriptarCadena($_POST['correo_electronico'] . $_POST['id_cliente_cofi']) . "'>Click aquí para activar tu cuenta</a></p>
            <p>Atentamente.</p>
            <p>CofiSystem</p>
            <p>R.U.C. 12345678901</p>
            <p>Área de sistemas</p>";

            $headers = "MIME-Version: 1.0" . "\r\n";
            $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
            $headers .= 'From: Remitente Cofi <no-responder@cofi.com.pe>' . "\r\n";

            enviarCorreo($_POST["correo_electronico"], $headers, "Active su cuenta de cofi.com.pe", $mensajeCorreo);
            $mainTransactionController->commit();
            $estadoRegistro = getMessage(200, "Aviso", "Su cuenta ha sido creada de manera satisfactoria, se le ha enviado al correo regitrado un enlace para activar la cuenta");
          } else {
            $mainTransactionController->rollBack();
            $estadoRegistro = getMessage(404, "¡Atención!", "Ocurrió un error al momento de crear su cuenta");
          }
        } catch (Exception $e) {
          $mainTransactionController->rollBack();
          $estadoRegistro = getMessage(404, "¡Atención!", "Ocurrió un error al momento de hacer la transacción: " . $e->getMessage());
        }
      } else {
        $estadoRegistro = getMessage(500, "¡Atención!", "Las claves ingresadas no coinciden");
      }
    } else {
      $estadoRegistro = getMessage(500, "¡Atención!", "Debe aceptar los terminos y condiciones");
    }
  }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Cofi | Registro usuario</title>

  <!-- Google Font: Source Sans Pro -->
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&amp;display=fallback">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="../src/css/fontawesome-all.min.css">
  <!-- Theme style -->
  <link rel="stylesheet" href="../src/css/adminlte.min.css">
</head>

<body class="hold-transition register-page">
  <div class="register-box">
    <div class="register-logo p-3">
      <img src="../src/img/cofi_h_c.png" height="65" />
    </div>

    <div class="card">
      <div class="card-body register-card-body">
        <p class="login-box-msg">Registro gratis con correo electrónico</p>

        <form action="registro-usuario.php" method="post">
          <div class="input-group mb-3">
            <input autocomplete="off" type="number" maxlength="11" onkeyup="limpiarNumero(this)"
            onchange="limpiarNumero(this)" onkeypress="soloNumeros(this)" class="form-control" name="ruc" placeholder="RUC (SUNAT)">
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-id-card"></span>
              </div>
            </div>
          </div>
          <div class="input-group mb-3">
            <input autocomplete="off" type="text" maxlength="100" class="form-control" name="razon_social" placeholder="Razón Social">
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-user"></span>
              </div>
            </div>
          </div>
          <div class="input-group mb-3">
            <input autocomplete="off" type="email" class="form-control" name="correo_electronico" placeholder="Correo electrónico">
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-envelope"></span>
              </div>
            </div>
          </div>
          <!--<div class="input-group mb-3">
            <input autocomplete="off" type="tel" maxlength="9" onkeyup="limpiarNumero(this)"
            onchange="limpiarNumero(this)" onkeypress="soloNumeros(this)" class="form-control" name="telefono" placeholder="Teléfono">
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-phone"></span>
              </div>
            </div>
          </div>-->
          <div class="input-group mb-3">
            <input autocomplete="off" type="password" class="form-control" name="clave" placeholder="Contraseña">
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-lock"></span>
              </div>
            </div>
          </div>
          <div class="input-group mb-3">
            <input autocomplete="off" type="password" class="form-control" name="repetir_clave" placeholder="Repertir contraseña">
            <div class="input-group-append">
              <div class="input-group-text">
                <span class="fas fa-lock"></span>
              </div>
            </div>
          </div>
          <div class="row">
            <div class="col-8">
              <div class="icheck-primary">
                <input autocomplete="off" type="checkbox" id="agreeTerms" name="chk_terminos" value="agree">
                <label for="agreeTerms">
                  Acepto los <a href="#">Términos</a>
                </label>
              </div>
            </div>
            <!-- /.col -->
            <div class="col-4">
              <button type="submit" class="btn btn-primary btn-block">Registrar</button>
            </div>
            <!-- /.col -->
          </div>
        </form>
        <?php echo $estadoRegistro; ?>

        <div class="mt-2">
          <span>¿Ya tienes una cuenta? </span><a href="index.php" class="text-center">Iniciar Sesión</a>
        </div>
      </div>
      <!-- /.form-box -->
    </div><!-- /.card -->
  </div>
  <!-- /.register-box -->


  <!-- jQuery -->
  <script src="../src/js/jquery.min.js"></script>
  <!-- Bootstrap 4 -->
  <script src="../src/js/bootstrap.bundle.min.js"></script>
  <!-- AdminLTE App -->
  <script src="../src/js/adminlte.min.js"></script>
  <script src="../src/js/forms.js"></script>
</body>

</html>