<?php
session_start();

require_once realpath(dirname(__FILE__) . '/../../Models/Empresa.php');
require_once realpath(dirname(__FILE__) . '/../../controllers/EmpresaControlador.php');

require_once realpath(dirname(__FILE__) . '/../../util/mensajes.php');
require_once realpath(dirname(__FILE__) . '/../../util/mes_anio.php');
require_once realpath(dirname(__FILE__) . '/../../util/cadenas.php');

$estadoRegistro = "";
if (isset($_SESSION["id_usuario"])) {
  $empresaModel = new Empresa();
  $empresaController = new EmpresaControlador($empresaModel);
  $resultadoListarEmpresaPublico = $empresaController->listarEmpresaPublico($_SESSION["id_usuario"]);

  if (isset($_POST) && !empty($_POST)) {
    $resultadoListarInformacionClienteCofi = $empresaController->listarEmpresaXId($_POST["cboEmpresa"]);

    $_SESSION["ruc"] = $resultadoListarInformacionClienteCofi[0]["ruc"];
    $_SESSION["client_id"] = encriptarCadena($resultadoListarInformacionClienteCofi[0]["client_id"]);
    $_SESSION["client_secret"] = encriptarCadena($resultadoListarInformacionClienteCofi[0]["client_secret"]);
    $_SESSION["usuario_sol"] = encriptarCadena($resultadoListarInformacionClienteCofi[0]["usuario_sol"]);
    $_SESSION["clave_sol"] = encriptarCadena($resultadoListarInformacionClienteCofi[0]["clave_sol"]);
    $_SESSION["periodo"] = $_POST["cboPeriodo"];
    $_SESSION["id_empresa"] = $_POST["cboEmpresa"];

    header('Location: ../empresa');
    exit;
  } else {
    $estadoRegistro = getMessage(500, "¡Atención!", "Seleccione una empresa y periodo para continuar");
  }
?>
  <!DOCTYPE html>
  <html lang="en">

  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Cofi - Sistema Contable</title>

    <!-- Google Font: Source Sans Pro -->
    <link rel="stylesheet"
      href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&amp;display=fallback">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="../src/css/fontawesome-all.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="../src/css/adminlte.min.css">
  </head>

  <body class="hold-transition login-page">
    <div class="login-box">
      <div class="login-logo p-3">
        <img src="../src/img/cofi_h_c.png" height="65" />
      </div>
      <!-- /.login-logo -->
      <div class="card">
        <div class="card-body login-card-body">
          <div class="row">
            <!-- /.col -->
            <div class="col">
              <div class="mb-2 text-right">
                <a href="login.php">Cerrar Sesión</a>
              </div>
            </div>
            <!-- /.col -->
          </div>
          <p class="login-box-msg">Seleccionar empresa</p>

          <form action="selecciona-empresa.php" method="post">
            <div class="form-group">
              <select class="form-control" name="cboEmpresa" required>
                <option value="">-- Seleccione empresa --</option>
                <?php
                foreach ($resultadoListarEmpresaPublico as $empresa) {
                ?>
                  <option value="<?php echo $empresa["id_empresa"]; ?>"><?php echo $empresa["razon_social"]; ?></option>
                <?php
                }
                ?>
              </select>
            </div>

            <div class="form-group">
              <select class="form-control" name="cboPeriodo" required>
                <option value="">-- Seleccione periodo --</option>
                <?php
                echo generarComboMesAnho();
                ?>
              </select>
            </div>
            <div class="row">
              <!-- /.col -->
              <div class="col">
                <button type="submit" class="btn btn-primary btn-block">Continuar</button>
              </div>
              <!-- /.col -->
            </div>
          </form>
          <div class="mt-2">
            <a href="../empresa/registro-empresa.php" class="text-center">Regístrar empresa nueva</a>
          </div>
        </div>
        <!-- /.login-card-body -->
      </div>
    </div>
    <!-- /.login-box -->

    <!-- jQuery -->
    <script src="../src/js/jquery.min.js"></script>
    <!-- AdminLTE App -->
    <script src="../src/js/adminlte.min.js"></script>
  </body>

  </html>
<?php
} else {
  header('Location: login.php');
}
?>